<?php 

add_action( 'wp_enqueue_scripts', 'salient_child_enqueue_styles');
function salient_child_enqueue_styles() {
	
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', array('font-awesome'));

    if ( is_rtl() ) 
   		wp_enqueue_style(  'salient-rtl',  get_template_directory_uri(). '/rtl.css', array(), '1', 'screen' );
	
  wp_enqueue_script('jquery-print', get_stylesheet_directory_uri(). '/js/jquery.print.js', array('jquery'));
  wp_enqueue_script('urljs', get_stylesheet_directory_uri(). '/js/url.js', array('jquery'));
  wp_enqueue_script('site', get_stylesheet_directory_uri(). '/js/site.js', array('jquery', 'urljs', 'jquery-print'));
  
  wp_localize_script('site', 'wp_ajax', array(
    'ajax_url' => admin_url('admin-ajax.php'),
    'nonce'    => wp_create_nonce('ajax_nonce')
  ));
}





/*
add_filter('script_loader_tag', 'add_script_defer', 10, 3);
function add_script_defer($tag, $handle, $src) {
  if(strpos($tag, " defer='defer'") !== false) return $tag;
  return str_replace(" type='text/javascript'", " type='text/javascript' defer='defer'", $tag);
}
*/

add_filter('get_user_option_show_admin_bar_front', 'override_user_opt_admin_bar', 99999, 3);
function override_user_opt_admin_bar($result, $option, $user) {
  if(!current_user_can('subscriber') || $option !== 'show_admin_bar_front') return $result;
  return 'false';
}

add_action('admin_init', 'theme_admin_init');
function theme_admin_init() {
  if(!current_user_can('subscriber')) return;
  remove_meta_box('dashboard_primary',  'dashboard', '');
  remove_meta_box('dashboard_activity', 'dashboard', '');
}

add_action('login_enqueue_scripts', 'theme_login_scripts');
function theme_login_scripts() {
  wp_enqueue_style('custom-login', get_stylesheet_directory_uri().'/style-login.css');
}

add_action('register_new_user', 'new_user_hook');
function new_user_hook($user_id) {
  update_user_meta($user_id, 'show_admin_bar_front', 'false');
}

add_action('init', 'handle_browse_listings');
function handle_browse_listings() {
  if(!is_page_template('single-listing.php')) return;
  if(session_status() !== PHP_SESSION_ACTIVE) session_start();
  
  if(!is_array($_SESSION['browsed_listings']))
    $_SESSION['browsed_listings'] = array();
  
  $mlsid = trim(@$_GET['mlsid']);
  $browsed_listings = &$_SESSION['browsed_listings'];
  
  if(!strlen($mlsid) || in_array($mlsid, $browsed_listings)) return;
  
  if(count($browsed_listings) >= 3)
    wp_redirect(wp_login_url(get_current_url(true)));
  
  $browsed_listings[] = $mlsid;
}

add_action('wp_ajax_fav_listing', 'ajax_fav_listing');
function ajax_fav_listing() {
  $resp = (object)array('error'=>true);
  
  $nonce = trim(@$_POST['_ajax_nonce']);
  if(!wp_verify_nonce($nonce, 'ajax_nonce')) ajax_die($resp);
  
  $data = @json_decode(base64_decode(trim(@$_POST['data'])));
  $uid = get_current_user_id();
  $unfav = !!@$data->unfav;
  $listings = array_unique(array_filter(array_map('trim', @$data->listings ?: array())));
  $ufavs = get_user_meta($uid, 'fav-listings', true) ?: array();
  
  $ufavs = $unfav ? 
    array_values(array_diff($ufavs, $listings)) :
    array_values(array_unique(array_merge($listings, $ufavs)));
  
  $resp->error = !update_user_meta($uid, 'fav-listings', $ufavs);
  ajax_die($resp);
}



add_filter('vc_wpb_getimagesize', 'vc_getimgsize', 10, 3);
function vc_getimgsize($img, $attach_id, $params) {
  $img['thumbnail'] = img_lazy_load($img['thumbnail']);
  return $img;
}



function ajax_die($resp = '') {
  header('Content-Type: application/json');
  ob_clean();
  echo json_encode($resp);
  wp_die();
}

function get_current_url($full = false) {
  $url = $_SERVER['REQUEST_URI'];
  if($full) {
    $proto = trim(@$_SERVER['HTTPS']) === 'on' ? 'https' : 'http';
    $url = $proto.'://'.$_SERVER['HTTP_HOST'].$url;
  }
  return $url;
}

function img_lazy_load($img_html) {
  return apply_filters('bj_lazy_load_html', $img_html);
}

function get_php_output($fn) {
  ob_start();
  call_user_func_array($fn, func_get_args());
  return ob_get_clean();
}

require_once(__DIR__.'/rets/rets-wp.php');



