<?php
$props = apply_filters('rets-featured', array());

?>
<div class="container featured-property">
	
	<div class="row">
		<div class="col span_12">
			<h2 class="big-title">Shop Edgewater Properties</h2>
		</div>	
	</div>
	
	<div class="row">
		<div class="col span_12 hr-line">
		</div>	
	</div>
	
	<div class="row listing-boxes">
<?php
foreach($props as $prop):
  $mlsid = trim(@$prop->MLSNumber); if(!$mlsid) continue;
  $price = '$'.number_format(floatval(@$prop->ListPrice), 0);
  $sqft  = number_format(floatval(@$prop->SqFtLivArea), 0);
  $beds  = intval(@$prop->BedsTotal);
  $baths = round(floatval(@$prop->BathsTotal), 2);
  $thumb = trim(@$prop->_photos['Photo'][0]);
  
  $beds_lbl  = $beds  > 1 ? 'Beds' : 'Bed';
  $baths_lbl = $baths > 1 ? 'Baths' : 'Bath';

  $unitnum = trim(@$prop->UnitNumber);
  $addr1 = array();
  $addr1[] = trim(@$prop->StreetNumber);
  $addr1[] = trim(@$prop->StreetDirPrefix);
  $addr1[] = trim(@$prop->StreetName);
  $addr1[] = trim(@$prop->StreetSuffix);
  $addr1[] = trim(@$prop->StreetDirSuffix);
  $addr1[] = $unitnum ? '#'.$unitnum : '';
  $addr1 = implode(' ', array_filter($addr1));

  $addr2 = array();
  $addr2[] = trim(@$prop->City).',';
  $addr2[] = trim(@$prop->StateOrProvince);
  $addr2[] = trim(@$prop->PostalCode);
  $addr2 = implode(' ', array_filter($addr2));

  if($thumb) $thumb = ' style="background-image:url(\''.htmlentities($thumb, ENT_QUOTES | ENT_HTML401).'\');"';
?>

		<a href="<?= home_url().'/property/?mlsid='.urlencode($mlsid) ?>" class="col span_3 prop-all"<?= $thumb ?>>
			<div class="row inside-top-row">
				<div class="col span_6">
					<h2 class="price"><?= $price ?></h2>
				</div>
				<div class="col span_6 address">
					<p><?= $addr1 ?></p>
					<p><?= $addr2 ?></p>
				</div>				
			</div>			
			
			<div class="row inside-bottom-row">
				<div class="col span_4">
					<h2><?= $beds ?></h2>
					<h4><?= $beds_lbl ?></h4>
				</div>
				<div class="col span_4">
					<h2><?= $baths ?></h2>
					<h4><?= $baths_lbl ?></h4>
				</div>
				<div class="col span_4">
					<h2><?= $sqft ?></h2>
					<h4>Sq. Ft.</h4>
				</div>
			</div>			
		</a>
<?php
endforeach;
?>

	</div><!-- end Row -->
</div><!-- end Container -->