jQuery(function($){
  
  var pItems = $('.portfolio-items');
  $('.portfolio-items .col img').on('lazyloaded', function(e){
    pItems.isotope('layout');
  });
  
	$('.view-all-btn-wrap a').click(function(ev){
		ev.preventDefault();
		$(this).parent().hide();
		$('.portfolio-wrap .portfolio-items > .col').show();
		$('.portfolio-items').isotope('layout');
	});
  
  $('#slide-out-widget-area .inner .off-canvas-menu-container li a').click(function(ev){
    $('#slide-out-widget-area .slide_out_area_close')
      .addClass('non-human-allowed')
      .trigger('click')
      .removeClass('non-human-allowed');
  });
  
  
	$(".print-me").click(function(ev){
		ev.preventDefault();
		$("div.print-area").print({
			timeout: 10000
		});
	});
  
  
  $('.fav-link-remove a').click(function(ev){
    ev.preventDefault();
    var $this = $(this);
    var mlsid = ($this.attr('data-mlsid') || '').trim();
    if(!mlsid) return;
    
    $this.css('visibility', 'hidden');
    
    save_favs(mlsid, true, function(data){
      if(data && data.error) {
        $this.css('visibility', 'visible');
        return;
      }
      $this.closest('tr').detach();
    });
    
  });
  
  
  $('.fav-listing-btn').click(function(ev){
    ev.preventDefault();
    var mlsid = ($.url('?mlsid') || '').trim();
    if(!mlsid) return;
    
    var cls = 'my-fav-listing';
    var $this = $(this);
    var hasFav = $this.hasClass(cls);
    
    $this[hasFav?'removeClass':'addClass'](cls);
    
    save_favs(mlsid, hasFav, function(data){
      if(data && data.error) $this.toggleClass(cls);
    });
    
  });
  
  
  function save_favs(listings, unfav, cb) {
    if(!(listings instanceof Array)) listings = [listings];
    if(!(cb instanceof Function)) cb = function(){};
    unfav = !!unfav;
    
    $.post(wp_ajax.ajax_url, {
      _ajax_nonce: wp_ajax.nonce,
      action: 'fav_listing',
      data: btoa(JSON.stringify({
        listings: listings,
        unfav: unfav
      }))
    }, cb);
  }
  
});
