<?php 
/*template name: Search Results - Grid*/

get_header();
nectar_page_header($post->ID); 

//full page
$fp_options = nectar_get_full_page_options();
extract($fp_options);

$search = trim(@$_GET['search']);
$props = apply_filters('rets-search', array(), $search) ?: array();
?>

<div class="container-wrap">

<div class="container featured-property ftrd-prop-results">
	
	<div class="row">
		<div class="col span_12">
			<h2 class="big-title">SEARCH RESULTS</h2>
		</div>	
	</div>
	
	<div class="row">
		<div class="col span_12 hr-line">
		</div>	
	</div>

<?php
if($props):
$pcount = count($props);
?>

<?php
foreach($props as $idx=>$prop):
  $mlsid = trim(@$prop->MLSNumber); if(!$mlsid) continue;
  $price = '$'.number_format(floatval(@$prop->ListPrice), 0);
  $sqft  = number_format(floatval(@$prop->SqFtLivArea), 0);
  $beds  = intval(@$prop->BedsTotal);
  $baths = round(floatval(@$prop->BathsTotal), 2);
  $thumb = trim(@$prop->_photos['Photo'][0]);
  $row   = $idx % 4;
  
  $beds_lbl  = $beds  > 1 ? 'Beds' : 'Bed';
  $baths_lbl = $baths > 1 ? 'Baths' : 'Bath';

  $unitnum = trim(@$prop->UnitNumber);
  $addr1 = array();
  $addr1[] = trim(@$prop->StreetNumber);
  $addr1[] = trim(@$prop->StreetDirPrefix);
  $addr1[] = trim(@$prop->StreetName);
  $addr1[] = trim(@$prop->StreetSuffix);
  $addr1[] = trim(@$prop->StreetDirSuffix);
  $addr1[] = $unitnum ? '#'.$unitnum : '';
  $addr1 = implode(' ', array_filter($addr1));

  $addr2 = array();
  $addr2[] = trim(@$prop->City).',';
  $addr2[] = trim(@$prop->StateOrProvince);
  $addr2[] = trim(@$prop->PostalCode);
  $addr2 = implode(' ', array_filter($addr2));

  if($thumb) $thumb = ' style="background-image:url(\''.htmlentities($thumb, ENT_QUOTES | ENT_HTML401).'\');"';
?>

	<?php if(!$row): ?><div class="row listing-boxes"><?php endif; ?>
		<a href="<?= home_url().'/property/?mlsid='.urlencode($mlsid) ?>" class="col span_3 prop-all"<?= $thumb ?>>
			<div class="row inside-top-row">
				<div class="col span_6">
					<h2 class="price"><?= $price ?></h2>
				</div>
				<div class="col span_6 address">
					<p><?= $addr1 ?></p>
					<p><?= $addr2 ?></p>
				</div>				
			</div>			
			
			<div class="row inside-bottom-row">
				<div class="col span_4">
					<h2><?= $beds ?></h2>
					<h4><?= $beds_lbl ?></h4>
				</div>
				<div class="col span_4">
					<h2><?= $baths ?></h2>
					<h4><?= $baths_lbl ?></h4>
				</div>
				<div class="col span_4">
					<h2><?= $sqft ?></h2>
					<h4>Sq. Ft.</h4>
				</div>
			</div>			
		</a>
	<?php if($row === 3 || $pcount === ($idx+1)): ?></div><!-- end Row --><?php endif; ?>
<?php
endforeach;
?>

<?php else: ?>
	<div class="row favorites">
		<div class="col span_12">
      <h1>No results found</h1>
		</div><!-- end Column -->	
	</div><!-- end Row and Favorites -->	
<?php endif; ?>
</div><!-- end Container -->
	

	
<?php get_footer(); ?>	