<?php 
/*template name: Search Results - Table*/

get_header();
nectar_page_header($post->ID); 

//full page
$fp_options = nectar_get_full_page_options();
extract($fp_options);

$search = trim(@$_GET['search']);
$props = apply_filters('rets-search', array(), $search) ?: array();
?>

<div class="container-wrap">

<?php get_template_part( 'includes/content', 'page' ); ?>
	
<div class="container">
	<div class="row">
		
		<div class="col span_12">
			<h2>SEARCH RESULTS</h2>
		</div>
	
	</div>
<?php
if($props):
?>
	<div class="row favorites">
		<div class="col span_12">
			
			<div class="favorites-wrapper">
				
				<table>
					<thead>
						<tr>
							<td>Unit #</td>
							<td>List Price</td>
							<td>Price SF</td>
							<td>Bed / Bath</td>
							<td>SQ FT</td>
							<td>MLS</td>				
						</tr>	
					</thead>
					<tbody>
<?php
$home_url = home_url();
foreach($props as $prop):
$me       = get_current_url(true);
$unitnum  = trim(@$prop->UnitNumber);
$lp       = floatval(@$prop->ListPrice);
$price    = '$'.number_format($lp, 0);
$sqftliv  = floatval(@$prop->SqFtLivArea);
$sqft     = number_format($sqftliv, 0);
$prcsqft  = '$'.number_format(round(floatval(@$prop->LPAmtSqFt), 0), 0);
$beds     = intval(@$prop->BedsTotal);
$baths    = round(floatval(@$prop->BathsTotal), 2);
$mlsid    = trim(@$prop->MLSNumber);

if($unitnum) $unitnum = '#'.$unitnum;
$prop_page = $home_url.'/property/?mlsid='.urlencode($mlsid);
?>
						<tr>
							<td class="fav-link"><a href="<?= $prop_page ?>"><?= $unitnum ?></a></td>
							<td><?= $price ?></td>
							<td><?= $prcsqft ?></td>
							<td><?= $beds ?> Bed(s) / <?= $baths ?> Bath(s)</td>
							<td><?= $sqft ?></td>
							<td class="fav-link"><a href="<?= $prop_page ?>"><?= $mlsid ?></a></td>
						</tr>
<?php endforeach; ?>
					</tbody>
				</table>
				
			</div><!-- end Favorites wrapper -->	
			
		</div><!-- end Column -->	
	</div><!-- end Row and Favorites -->	
<?php else: ?>
	<div class="row favorites">
		<div class="col span_12">
      <h1>No results found</h1>
		</div><!-- end Column -->	
	</div><!-- end Row and Favorites -->	
<?php endif; ?>
	
</div><!-- end Container -->
	

	
<?php get_footer(); ?>	