<?php 
/*template name: Single Listing*/

//full page
$fp_options = nectar_get_full_page_options();
extract($fp_options);

$mlsid = trim(@$_GET['mlsid']);
$prop = new stdClass;

if($mlsid) {
  $prop = apply_filters('rets-mls', $prop, $mlsid);
}

$me       = get_current_url(true);
$city     = trim(@$prop->City);
$state    = trim(@$prop->StateOrProvince);
$zip      = trim(@$prop->PostalCode);
$subdivnam = trim(@$prop->SubdivisionName);
$subdivbld = trim(@$prop->SubdivisionComplexBldg);
$devname  = trim(@$prop->DevelopmentName);
$subdiv   = $subdivnam ?: $subdivbld;
$lp       = floatval(@$prop->ListPrice);
$lastlp   = floatval(@$prop->LastListPrice);
$lpdiff   = $lastlp ? sprintf("%+.2f%%", -round(100*(1-$lp/$lastlp), 2)) : '';
$lpdiffs  = str_replace('-', '&ndash;', $lpdiff);
$mlsid    = trim(@$prop->MLSNumber);
$price    = '$'.number_format($lp, 0);
$sqftliv  = floatval(@$prop->SqFtLivArea);
$sqft     = number_format($sqftliv, 0);
$prcsqft  = '$'.number_format(round(floatval(@$prop->LPAmtSqFt), 0), 0);
$beds     = intval(@$prop->BedsTotal);
$baths    = round(floatval(@$prop->BathsTotal), 2);
$baths_full = trim(@$prop->BathsFull);
$baths_half = trim(@$prop->BathsHalf) ?: '0';
$yrblt    = trim(@$prop->YearBuilt);
$proptype = trim(@$prop->PropertyType);
$wtrft    = filter_var(trim(@$prop->WaterfrontPropertyYN), FILTER_VALIDATE_BOOLEAN) ? 'Yes' : 'No';
$style    = trim(@$prop->Style);
$park     = join('<br />', explode(',',trim(@$prop->ParkingDescription)));
$amint    = explode(',',trim(@$prop->Amenities));
$poolyn   = filter_var(trim(@$prop->PoolYN), FILTER_VALIDATE_BOOLEAN);
$pool     = $poolyn ? 'Yes' : (in_array('Pool', $amint) ? 'Yes' : 'No');
$dom      = trim(@$prop->DOM);
$lsttype  = trim(@$prop->ListingType);
$status   = trim(@$prop->Status);
$remark   = str_replace("\n", '<br />', str_replace("\r", '', trim(@$prop->Remarks)));
$iremrk   = trim(@$prop->InternetRemarks);
$const    = trim(@$prop->ConstructionType);
$furnish  = trim(@$prop->FurnishedInfoList);
$taxyear  = trim(@$prop->TaxYear);
$taxes    = '$'.number_format(round(floatval(@$prop->TaxAmount), 0), 0);
$hoafee   = '$'.number_format(round(floatval(@$prop->AssociationFee), 0), 0);
$petrest  = join(', ', explode(',',trim(@$prop->PetRestrictions)));
$lstdate  = strtotime(trim(@$prop->OriginalEntryTimestamp));
$lstdate_lbl = date('m/d/Y', $lstdate);
$flooring = join(', ', explode(',',trim(@$prop->FloorDescription)));
$view     = join(', ', array_filter(array_merge(explode(',', trim(@$prop->UnitView)), explode(',', trim(@$prop->View)))));

$thumbs  = @$prop->_photos['Photo'] ?: array();       // thumbnail images
$photos  = @$prop->_photos['LargePhoto'] ?: array();  // "normal" size (not high-res)
//$highres = @$prop->_photos['HighRes'] ?: array();     // largest size available

$beds_lbl  = $beds  > 1 ? 'beds' : 'bed';
$baths_lbl = $baths > 1 ? 'baths' : 'bath';

$unitnum = trim(@$prop->UnitNumber);
$addr1   = array();
$addr1[] = trim(@$prop->StreetNumber);
$addr1[] = trim(@$prop->StreetDirPrefix);
$addr1[] = trim(@$prop->StreetName);
$addr1[] = trim(@$prop->StreetSuffix);
$addr1[] = trim(@$prop->StreetDirSuffix);
$addr1[] = $unitnum ? '#'.$unitnum : '';
$addr1   = implode(' ', array_filter($addr1));

$addr2   = array();
$addr2[] = $city.',';
$addr2[] = $state;
$addr2[] = $zip;
$addr2   = implode(' ', array_filter($addr2));

$addr = $addr1.', '.$addr2;


$uid = get_current_user_id();
$ufavs = get_user_meta($uid, 'fav-listings', true) ?: array();

$myfav = in_array($mlsid, $ufavs) ? ' my-fav-listing' : '';
$favbtn = is_user_logged_in() ? ' fav-listing-btn' : '';


add_filter('pre_get_document_title', 'assignPageTitle', 99999);
function assignPageTitle($title){
  global $addr;
  return $addr.' - '.get_bloginfo('name');
}


get_header();
nectar_page_header($post->ID);


echo "<!--\n"; print_r($prop); echo "-->\n";

?>

<div class="container-wrap">
<div class="print-area">
<?php get_template_part( 'includes/content', 'page' ); ?>

<?php if(isset($prop->MLSNumber)): ?>
	<div class="container-fluid">
		<div class="row padded-row">	
	
			<div class="col span_12 property-address-details">
				<h2><?= $addr ?></h2>
			</div>
		</div>		
	</div>		
	
	<div class="container-fluid">
		<div class="row padded-row align-stretch">			
			
			<div class="col span_6">
				<?php //echo do_shortcode ('[rev_slider alias="single-listing"]') ?>


				
<div id="rev_slider_2_1_wrapper" class="rev_slider_wrapper fullwidthbanner-container" data-source="gallery" style="margin:0px auto;background:#111111;padding:0px;margin-top:0px;margin-bottom:0px;">
<!-- START REVOLUTION SLIDER 5.4.7.1 auto mode -->
	<div id="rev_slider_2_1" class="rev_slider fullwidthabanner" style="display:none;" data-version="5.4.7.1">
<ul>
<?php
foreach($thumbs as $idx=>$thumb):
if(!$thumb || !$idx) continue;
$photo = @$photos[$idx];
$id = $idx+1;
?>
	<li data-index="rs-<?= $id ?>" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="300"  data-thumb="<?= $thumb ?>"  data-rotate="0"  data-saveperformance="off"  data-title="Slide" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
		<img src="<?= $photo ?>"  alt="" title=""  width="1200" height="627" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="off" class="rev-slidebg" data-no-retina />
	</li>
<?php
endforeach;
?>
</ul>
<script>var htmlDiv = document.getElementById("rs-plugin-settings-inline-css"); var htmlDivCss="";
						if(htmlDiv) {
							htmlDiv.innerHTML = htmlDiv.innerHTML + htmlDivCss;
						}else{
							var htmlDiv = document.createElement("div");
							htmlDiv.innerHTML = "<style>" + htmlDivCss + "</style>";
							document.getElementsByTagName("head")[0].appendChild(htmlDiv.childNodes[0]);
						}
					</script>
<div class="tp-bannertimer" style="height: 5px; background: rgba(0,0,0,0.15);"></div>	</div>
<script>var htmlDiv = document.getElementById("rs-plugin-settings-inline-css"); var htmlDivCss="";
				if(htmlDiv) {
					htmlDiv.innerHTML = htmlDiv.innerHTML + htmlDivCss;
				}else{
					var htmlDiv = document.createElement("div");
					htmlDiv.innerHTML = "<style>" + htmlDivCss + "</style>";
					document.getElementsByTagName("head")[0].appendChild(htmlDiv.childNodes[0]);
				}
			</script>
		<script type="text/javascript">
if (setREVStartSize!==undefined) setREVStartSize(
	{c: '#rev_slider_2_1', gridwidth: [720], gridheight: [405], sliderLayout: 'auto'});
			
var revapi2,
	tpj;	
(function() {			
	if (!/loaded|interactive|complete/.test(document.readyState)) document.addEventListener("DOMContentLoaded",onLoad)
		else
	onLoad();
	
	function onLoad() {				
		if (tpj===undefined) {
			tpj = jQuery;

			if("off" == "on") tpj.noConflict();		
		}
	if(tpj("#rev_slider_2_1").revolution == undefined){
		revslider_showDoubleJqueryError("#rev_slider_2_1");
	}else{
		revapi2 = tpj("#rev_slider_2_1").show().revolution({
			sliderType:"carousel",
			jsFileLocation:"<?= site_url() ?>/wp-content/plugins/revslider/public/assets/js/",
			sliderLayout:"auto",
			dottedOverlay:"none",
			delay:9000,
			navigation: {
				keyboardNavigation:"off",
				keyboard_direction: "horizontal",
				mouseScrollNavigation:"off",
 							mouseScrollReverse:"default",
				onHoverStop:"off",
				touch:{
					touchenabled:"on",
					touchOnDesktop:"off",
					swipe_threshold: 75,
					swipe_min_touches: 50,
					swipe_direction: "horizontal",
					drag_block_vertical: false
				}
				,
				arrows: {
					style:"gyges",
					enable:true,
					hide_onmobile:false,
					hide_onleave:false,
					tmp:'',
					left: {
						h_align:"left",
						v_align:"center",
						h_offset:30,
						v_offset:0
					},
					right: {
						h_align:"right",
						v_align:"center",
						h_offset:30,
						v_offset:0
					}
				}
				,
				thumbnails: {
					style:"gyges",
					enable:true,
					width:60,
					height:60,
					min_width:60,
					wrapper_padding:20,
					wrapper_color:"rgb(34,34,34)",
					tmp:'<span class="tp-thumb-img-wrap">  <span class="tp-thumb-image"></span></span>',
					visibleAmount:9,
					hide_onmobile:false,
					hide_onleave:false,
					direction:"horizontal",
					span:true,
					position:"outer-bottom",
					space:10,
					h_align:"center",
					v_align:"bottom",
					h_offset:0,
					v_offset:0
				}
			},
			carousel: {
				horizontal_align: "center",
				vertical_align: "center",
				fadeout: "on",
				vary_fade: "on",
				maxVisibleItems: 3,
				infinity: "on",
				space: 0,
				stretch: "off",
 							showLayersAllTime: "off",
 							easing: "Power3.easeInOut",
 							speed: "800"
			},
			visibilityLevels:[1240,1024,778,480],
			gridwidth:720,
			gridheight:405,
			lazyType:"none",
			parallax: {
				type:"mouse",
				origo:"slidercenter",
				speed:2000,
				speedbg:0,
				speedls:0,
				levels:[2,3,4,5,6,7,12,16,10,50,47,48,49,50,51,55],
			},
			shadow:0,
			spinner:"off",
			stopLoop:"on",
			stopAfterLoops:0,
			stopAtSlide:1,
			shuffle:"off",
			autoHeight:"off",
			hideThumbsOnMobile:"off",
			hideSliderAtLimit:0,
			hideCaptionAtLimit:0,
			hideAllCaptionAtLilmit:0,
			debugMode:false,
			fallbacks: {
				simplifyAll:"off",
				nextSlideOnWindowFocus:"off",
				disableFocusListener:false,
			}
		});
	}; /* END OF revapi call */
	
 }; /* END OF ON LOAD FUNCTION */
}()); /* END OF WRAPPING FUNCTION */
</script>
		<script>
					var htmlDivCss = unescape("%0A.gyges%20.tp-thumb%20%7B%20%0A%20%20%20%20%20%20opacity%3A1%0A%20%20%7D%0A.gyges%20.tp-thumb-img-wrap%20%7B%0A%20%20padding%3A3px%3B%0A%20%20background-color%3Argba%280%2C0%2C0%2C0.25%29%3B%0A%20%20display%3Ainline-block%3B%0A%0A%20%20width%3A100%25%3B%0A%20%20height%3A100%25%3B%0A%20%20position%3Arelative%3B%0A%20%20margin%3A0px%3B%0A%20%20box-sizing%3Aborder-box%3B%0A%20%20%20%20transition%3Aall%200.3s%3B%0A%20%20%20%20-webkit-transition%3Aall%200.3s%3B%0A%7D%0A.gyges%20.tp-thumb-image%20%7B%0A%20%20%20padding%3A3px%3B%20%0A%20%20%20display%3Ablock%3B%0A%20%20%20box-sizing%3Aborder-box%3B%0A%20%20%20position%3Arelative%3B%0A%20%20%20%20-webkit-box-shadow%3A%20inset%205px%205px%2010px%200px%20rgba%280%2C0%2C0%2C0.25%29%3B%0A%20%20-moz-box-shadow%3A%20inset%205px%205px%2010px%200px%20rgba%280%2C0%2C0%2C0.25%29%3B%0A%20%20box-shadow%3A%20inset%205px%205px%2010px%200px%20rgba%280%2C0%2C0%2C0.25%29%3B%0A%20%7D%20%20%0A%0A.gyges%20.tp-thumb%3Ahover%20.tp-thumb-img-wrap%2C%0A%20.gyges%20.tp-thumb.selected%20.tp-thumb-img-wrap%20%7B%0A%20%20%20%20background%3A%20-moz-linear-gradient%28top%2C%20%20rgba%28255%2C%20255%2C%20255%2C%201%29%200%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%20100%25%29%3B%0Abackground%3A%20-webkit-gradient%28left%20top%2C%20left%20bottom%2C%20color-stop%280%25%2C%20rgba%28255%2C%20255%2C%20255%2C%201%29%29%2C%20color-stop%28100%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%29%29%3B%0Abackground%3A%20-webkit-linear-gradient%28top%2C%20rgba%28255%2C%20255%2C%20255%2C%201%29%200%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%20100%25%29%3B%0Abackground%3A%20-o-linear-gradient%28top%2C%20rgba%28255%2C%20255%2C%20255%2C%201%29%200%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%20100%25%29%3B%0Abackground%3A%20-ms-linear-gradient%28top%2C%20rgba%28255%2C%20255%2C%20255%2C%201%29%200%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%20100%25%29%3B%0Abackground%3A%20linear-gradient%28to%20bottom%2C%20rgba%28255%2C%20255%2C%20255%2C%201%29%200%25%2C%20rgba%28119%2C%20119%2C%20119%2C%201%29%20100%25%29%3B%0A%0A%7D%0A%0A%0A");
					var htmlDiv = document.getElementById('rs-plugin-settings-inline-css');
					if(htmlDiv) {
						htmlDiv.innerHTML = htmlDiv.innerHTML + htmlDivCss;
					}
					else{
						var htmlDiv = document.createElement('div');
						htmlDiv.innerHTML = '<style>' + htmlDivCss + '</style>';
						document.getElementsByTagName('head')[0].appendChild(htmlDiv.childNodes[0]);
					}
				  </script>
				</div><!-- END REVOLUTION SLIDER -->



			</div>
	
	
			<div class="col span_3">
				
				<div class="property-details-wrapper">
					<div class="details">
						
						<h2><?= $price ?></h2>
						
						<div class="row-with-icons">
							<div class="detail-blocks">
								<p><i class="fa fa-bed"></i></p>
								<p><?= $beds.' '.$beds_lbl ?></p>
							</div>
							<div class="detail-blocks">
								<p><i class="fa fa-bath"></i></p>
								<p><?= $baths.' '.$baths_lbl ?></p>
							</div>
							<div class="detail-blocks">
								<p><i class="fa fa-arrows"></i></p>
								<p><?= $sqft ?> SF</p>
							</div>
						</div>
						
						<div class="clear"></div>
						
						<table>
							<tbody>
								<tr>
									<td>MLS</td>
									<td><?= $mlsid ?></td>
								</tr>
								<tr>
									<td>Living Size</td>
									<td><?= $sqft ?></td>
								</tr>
								<tr>
									<td>Year Built</td>
									<td><?= $yrblt ?></td>
								</tr>
								<tr>
									<td>Waterfront</td>
									<td><?= $wtrft ?></td>
								</tr>
								<tr>
									<td>Zip</td>
									<td><?= $zip ?></td>
								</tr>
								<tr>
									<td>Style</td>
									<td><?= $style ?></td>
								</tr>
								<tr>
									<td>Parking</td>
									<td><?= $park ?></td>
								</tr>
								<tr>
									<td>Swimming Pool</td>
									<td><?= $pool ?></td>
								</tr>
								<tr>
									<td>Status</td>
									<td><?= $status ?></td>
								</tr>								
							</tbody>	
						</table>	
						
					</div>	
				</div><!-- end Property Details Wraper -->	
				
			</div>
			
			<div class="col span_3">
				<div class="form-col-wrapper">
					<h2>Request More Info</h2>
					<?php echo do_shortcode('[formidable id=8]') ?>
				</div>	
			</div>	
			
		</div><!-- end row -->	
	</div><!-- end Container -->
	
	<div class="container-fluid">
		<div class="row padded-row share-button-row">
			
			<div class="col span_2<?= $favbtn.$myfav ?>">
				<p><a href="<?= wp_login_url($me) ?>"><i class="fa fa-heart-o"></i> Favorite</a></p>
			</div>
			
			<div class="col span_2">
				<p><a href="#" class="popmake-248"><i class="fa fa-envelope"></i> Email</a></p>
			</div>
			
			<div class="col span_2">
				<p><a onclick="window.open('https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($me) ?>','sharer','toolbar=0,status=0,width=548,height=325');" href="javascript:void(0);"><i class="fa fa-share-alt"></i> Share</a></p>
			</div>
			
			<div class="col span_2">
				<p><a class="print-me" href="#"><i class="fa fa-print"></i> Print</a></p>
			</div>
			
			<div class="col span_2">
				<p><a href="#" class="popmake-244"><i class="fa fa-calculator"></i> Calculator</a></p>
			</div>
			
			<div class="col span_2">
				<p><a href="https://www.google.com/maps?q=<?= urlencode($addr) ?>" target="_blank"><i class="fa fa-map-marker"></i> Directions</a></p>
			</div>			
			
		</div><!-- end row -->	
	</div><!-- end Container -->
	
	<div class="container-fluid">
		<div class="row padded-row">
			<div class="col span_12 prop-desc">
				<h2>Property Description</h2>
				<p><?= $remark ?></p>
			</div>	
		</div><!-- end row -->	
	</div><!-- end Container -->
	
	
	<div class="container-fluid">
		<div class="row padded-row prop-dtls">
			
			<div class="col span_3">
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>List Price</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $price ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Price Change</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $lpdiffs ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Beds</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $beds ?></p>
					</div>
				</div>	
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Baths</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $baths_full ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>1/2 Baths</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $baths_half ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Living Size</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $sqft ?> SF</p>
					</div>
				</div>				
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Price SF</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $prcsqft ?></p>
					</div>
				</div>	

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Year Built</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $yrblt ?></p>
					</div>
				</div>
				
			</div><!-- end Column -->
			
			<div class="col span_3">
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Waterfront</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $wtrft ?></p>
					</div>
				</div>				
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>View</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $view ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Swimming Pool</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $pool ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Style</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $style ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Construction</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $const ?></p>
					</div>
				</div>
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Parking</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $park ?></p>
					</div>
				</div>					

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Flooring Type</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $flooring ?></p>
					</div>
				</div>				
			</div><!-- end Column -->
			
			<div class="col span_3">
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>MLS</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $mlsid ?></p>
					</div>
				</div>				
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Property Type</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $proptype ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Status</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $status ?></p>
					</div>
				</div>	

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Sale Type</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $lsttype ?></p>
					</div>
				</div>	
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Date Listed</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $lstdate_lbl ?></p>
					</div>
				</div>					

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Days on Market</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $dom ?></p>
					</div>
				</div>

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Furnished</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $furnish ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Pet Restriction</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $petrest ?></p>
					</div>
				</div>					
				
			</div><!-- end Column -->
			
			<div class="col span_3">
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>City</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $city ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Zip</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $zip ?></p>
					</div>
				</div>					
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>State</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $state ?></p>
					</div>
				</div>	
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Subdivision</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $subdiv ?></p>
					</div>
				</div>					

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Development Name</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $devname ?></p>
					</div>
				</div>	

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>HOA</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $hoafee ?></p>
					</div>
				</div>	

				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Taxes</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $taxes ?></p>
					</div>
				</div>	
				
				<div class="clear some-row">
					<div class="float-left-data">
						<h2>Tax Year</h2>
					</div>	

					<div class="float-right-data">
						<p><?= $taxyear ?></p>
					</div>
				</div>					
			
			</div><!-- end Column -->
			
		</div><!-- end row -->	
	</div><!-- end Container -->
	
	<div class="container-fluid">
		<div class="row padded-row disclaimer-two">
			
			<div class="col span_12">
				<!--
        <p>Lorem ipsum dolor sit amet, his te vide mollis salutatus. Molestie scripserit et eos, putent aperiam adversarium eam et. Ludus latine id ius. Sensibus ocurreret ut vix, usu ut fastidii mnesarchum, quot exerci efficiantur eum ei. Eu veniam commodo est, est partiendo salutatus ad, est ex assum partem. Ius id mundi laudem expetendis. No everti conceptam vituperata nam. At odio velit numquam eum.</p>
        -->
			</div>	
			
		</div><!-- end row -->	
	</div><!-- end Container -->
<?php else: ?>
	<div class="container-fluid">
		<div class="row padded-row disclaimer-two">
			<div class="col span_12">
				<h2>No property found</h2>
			</div>
		</div>
	</div>
<?php endif; ?>
	</div><!-- end Print Area -->
	
<?php get_footer(); ?>