<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

$options = get_nectar_theme_options(); 
$product_style = (!empty($options['product_style'])) ? $options['product_style'] : 'classic';
?>

<?php if(function_exists('wc_get_loop_prop')) { ?>
  <ul class="products columns-<?php echo esc_attr( wc_get_loop_prop( 'columns' ) );?>" data-product-style="<?php echo $product_style; ?>">
<?php } else { ?>
  <ul class="products" data-product-style="<?php echo $product_style; ?>">
<?php } ?>


