<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>

<!--Section5 Start Here-->
    <?php 
    	$footer_form_title = get_field('form_title','option');
    	$footer_form_code = get_field('form_code','option');
    	$footer_form_data = do_shortcode($footer_form_code);
    ?>
    <?php if (is_front_page()): ?>
        <div class="section5 center">
            <div class="container">
                <?php if(isset($footer_form_title) && !empty($footer_form_title)) { ?>
                <div class="section-title wow fadeInUp" data-wow-delay="0.005s">
                    <h3 class="title-shadow"><?php echo $footer_form_title; ?></h3>
                    <h2><?php echo $footer_form_title; ?></h2>
                </div>
                <?php } ?>
                <?php if(isset($footer_form_data) && !empty($footer_form_data)) { ?>
                <div class="appointment-form-block">
                    <?php echo $footer_form_data; ?>
                </div>
                <?php } ?>
            </div>
        </div>
	<?php endif; ?>
</div>
<!-- Footer -->
<footer class="footer">
	<div class="container">
        <div class="footer-nav">
        	<?php
                    $defaults = array( 
		                            'menu' 			  => 'Main Menu',
		                            'menu_class' 	  => 'clearfix',
		                            'container_class' => ''
		                        );
                    wp_nav_menu( $defaults );
    		?>        	
        </div>
        <?php
        	if(have_rows('social_media','option')) :
        ?>
        <div class="social-icons">
        	<ul class="clearfix">
            	<?php while(have_rows('social_media','option')) { the_row(); 
            		$title = get_sub_field('title');
                	$link  = get_sub_field('link');
                	$icon  = get_sub_field('icon');	
            	?>
            	<li><a href="<?php echo $link; ?>"><i class="fa fa-<?php echo $icon; ?>" aria-hidden="true"></i></a></li>
            	<?php } ?>
            </ul>
        </div>
        <?php endif; ?>        
    </div>
    <?php
    	$copy_right_text1 	   = get_field('copy_right_text1', 'option');
    	$copy_right_text1_link = get_field('copy_right_text1_link', 'option');
    	$copy_right_text2 	   = get_field('copy_right_text2', 'option');
    ?>
    <div class="copyright">
        <p>© <?php echo date('Y'); ?> <?php if(isset($copy_right_text1) && !empty($copy_right_text1)) {?><a href="<?php echo $copy_right_text1_link; ?>"><?php echo $copy_right_text1; ?></a>.<?php } ?> <?php echo $copy_right_text2; ?></p>
    </div>	
</footer>
<a id="toTop" class="scrollup"><i class="fa fa-arrow-up" aria-hidden="true"></i></a>

<script src="<?php echo get_template_directory_uri(); ?>/assets/js/jquery-min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/js/commonscript.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/js/main.js"></script>
<!-- wp_footer Start Here-->		
<?php wp_footer(); ?>
<!-- wp_footer End Here-->
</body>
</html>
