<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

get_header(); ?>

<!-- Page Content -->
<div class="middle-section">

	<!--Home page Banner Section Start Here-->
	<?php if(have_rows('banner_section')) : ?>
    <div class="homeslider clearfix">
		<ul class="HomeSlick">
			<?php while(have_rows('banner_section')) { the_row();
				$banner_image = get_sub_field('banner_image','option');
				$title 		  = get_sub_field('title','option');
				$sub_title    = get_sub_field('sub_title','option');
				$content      = get_sub_field('content','option');
				$button_label = get_sub_field('button_label','option');
				$button_link  = get_sub_field('button_link','option');
			?> 
			<li style="background:url(<?php echo $banner_image; ?>) no-repeat center 0">
				<div class="caption">
                    <div class="container wow fadeInRight" data-wow-delay="0.005s">
                      <div class="caption-inner">
                      	<div class="caption-content">
                            <?php if(isset($sub_title) && !empty($sub_title)) { ?>
                            <span><?php echo $sub_title; ?></span>
                            <?php } ?>
                            <?php if(isset($title) && !empty($title)) { ?>
                            <h2><?php echo $title; ?></h2>
                            <?php } ?>
                            <?php if(isset($content) && !empty($content)) { ?>
                            <p><?php echo $content; ?></p>
                            <?php } ?>
                            <?php if(isset($button_label) && !empty($button_label)) { ?>
                            <a class="btn" href="<?php echo $button_link; ?>"><?php echo $button_label; ?></a>
                            <?php } ?>
                        </div>
                      </div>
                    </div>
                </div>
			</li>
            <?php } ?>           
		</ul>		
	</div>
	<?php endif; ?>
	<!--Home page Banner Section End Here-->

	<!--Section1 Start Here-->
	<?php
		$section1_title 	   = get_field('section1_title');
		$section1_image_title  = get_field('section1_image_title');
		$section1_image 	   = get_field('section1_image');
		$section1_content 	   = get_field('section1_content');
		$section1_button_label = get_field('section1_button_label');
		$section1_button_link  = get_field('section1_button_link');
	?>
	<div id="section1" class="section1">
    	<div class="container">
        	<div class="section1-left wow fadeIn" data-wow-delay="0.005s">
            	<?php if(isset($section1_image_title) && !empty($section1_image_title)) { ?>
            	<div class="left-title"><?php echo $section1_image_title; ?></div>
            	<?php } ?>
                <?php if(isset($section1_image) && !empty($section1_image)) { ?>
                <div class="imgbox"><img src="<?php echo $section1_image; ?>" alt=""></div>
                <?php } ?>
            </div>
            <div class="section1-right wow fadeIn" data-wow-delay="0.005s">
            	<?php if(isset($section1_title) && !empty($section1_title)) { ?>
            	<h2><?php echo $section1_title; ?></h2>
            	<?php } ?>
                <?php if(isset($section1_content) && !empty($section1_content)) { ?>
                <p><?php echo $section1_content; ?></p>
				<?php } ?>
				<?php if(isset($section1_button_label) && !empty($section1_button_label)) { ?>
				<a class="text-link" href="<?php echo $section1_button_link; ?>"><?php echo $section1_button_label; ?> <i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
				<?php }?>
            </div>
        </div>
	</div>
	<!--Section1 End Here-->

	<!--Section2 Start Here-->
	<?php
		$section2_title = get_field('section2_title');		
	?>
	<div id="section2" class="section2 center">
    	<div class="container">
        	<?php if(isset($section2_title) && !empty($section2_title)) { ?>
        	<div class="section-title wow fadeInUp" data-wow-delay="0.005s">
                <h3 class="title-shadow"><?php echo $section2_title; ?></h3>
                <h2><?php echo $section2_title; ?></h2>
            </div>
            <?php } ?>
            <?php if(have_rows('section2_content')) : ?>
            <div class="service-slider clearfix wow fadeInUp" data-wow-delay="0.005s">
            	<?php while(have_rows('section2_content')) { the_row();
            		$title 		  = get_sub_field('title'); 
            		$thumb_image  = get_sub_field('thumb_image');
            		$content 	  = get_sub_field('content');
            		$button_label = get_sub_field('button_label');
            		$button_link  = get_sub_field('button_link');
            	?>
            	<div class="serv-infobox">
                	<div class="serv-info-content">
                    	<?php if(isset($thumb_image) && !empty($thumb_image)) { ?>
                    	<a class="serv-imgbox" href="<?php echo $button_link; ?>"><img src="<?php echo $thumb_image; ?>" alt=""></a>
                    	<?php } ?>
                        <?php if(isset($title) && !empty($title)) { ?>
                        <h3><a href="<?php echo $button_link; ?>"><?php echo $title; ?></a></h3>
                        <?php } ?>
                        <?php if(isset($content) && !empty($content)) { ?>
                        <p><?php echo $content; ?></p>
                        <?php } ?>
                        <?php if(isset($button_label) && !empty($button_label)) { ?>
                        <a class="btn" href="<?php echo $button_link; ?>"><?php echo $button_label; ?></a>
                        <?php } ?>
                    </div>
                </div>
                <?php } ?> 
            </div>
        <?php endif; ?>
        </div>		
	</div>
	<!--Section2 End Here-->
	
	<!--Section3 Start Here-->
	<?php
		$section3_title = get_field('section3_title');		
	?>
	<div class="section3 center">
		<div class="container">
        	<?php if(isset($section3_title) && !empty($section3_title)) { ?>
        	<div class="section-title wow fadeInUp" data-wow-delay="0.005s">
            	<h3 class="title-shadow"><?php echo $section3_title; ?></h3>
                <h2><?php echo $section3_title; ?></h2>
            </div>
            <?php } ?>
            <?php if(have_rows('section3_content')) : ?>
            <div class="section3-inner wow fadeInUp" data-wow-delay="0.005s">
            	<ul class="testimonial-slider clearfix">
                	<?php while (have_rows('section3_content')) { the_row(); 
                		$iframe_data = get_sub_field('youtube_video_iframe');
                	?>	
                	<?php if(isset($iframe_data) && !empty($iframe_data)) { ?>
                	<li><div class="video-box"><?php echo $iframe_data; ?></div></li>
                	<?php } }?>
                </ul>
            </div>
        <?php endif; ?>
        </div>	
	</div>
	<!--Section3 End Here-->
	
	<!--Section4 Start Here-->
	<?php
		$section4_video_link = get_field('section4_video_link');		
	?>
	<?php if(isset($section4_video_link) && !empty($section4_video_link)) { ?>
	<div class="section4">
    	<div class="container">
        	<div class="full-width-video-box video-box wow fadeInUp" data-wow-delay="0.005s">
               	<?php echo $section4_video_link; ?>
            </div>
        </div>	
	</div>
	<?php } ?>
    <!--Section4 End Here-->

<script type="text/javascript">
//Scroll to Section
jQuery(".homeslider .caption-content > a, .section1-right > a.text-link").click(function(e){
	e.preventDefault();
	var hrefVal = jQuery(this).attr("href");
	var sectionOffset = jQuery(hrefVal).offset().top;
	jQuery('html, body').animate({
		scrollTop: sectionOffset
	}, 800);
});
</script>

<?php get_footer(); ?>