<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/assets/images/fevicon.png?='0'" />	
	<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,900" rel="stylesheet"> 
	<link href="<?php echo get_template_directory_uri(); ?>/assets/css/font-awesome.min.css" rel="stylesheet">
    <link href="<?php echo get_template_directory_uri(); ?>/assets/css/commonstyle.css" rel="stylesheet">
	<link href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css" rel="stylesheet">	
	<link href="<?php echo get_template_directory_uri(); ?>/assets/css/media.css" rel="stylesheet">

<!-- wp_head Start Here-->
<?php wp_head(); ?>
<!-- wp_head End Here-->
</head>

<body <?php body_class(); ?>>
<!--Header Start-->
<header class="header">
	<div class="container">
    		<?php
    			$header_logo_img 	   = get_field('logo_image', 'option');
    			$contact_number1_lable = get_field('contact_number1_lable','option');
            	$contact_number1 	   = get_field('contact_number1','option');
            	$contact_number2_lable = get_field('contact_number2_lable','option');
            	$contact_number2 	   = get_field('contact_number2','option');
            	$header_button_label   = get_field('header_button_label','option');
            	$header_button_link    = get_field('header_button_link','option');
                $checkout_button    = get_field('checkout_button','option');
                $checkout_button_link    = get_field('checkout_button_link','option');
                $cart_link    = get_field('cart_link','option');
    		?>
		<div class="header-main clearfix">
			<?php if(!empty($header_logo_img) && isset($header_logo_img)) { ?>
			<div class="logo"><a href="<?php echo home_url(); ?>" title="Roche Monitoring Services, LLC"><img src="<?php echo $header_logo_img; ?>" alt="Logo Image"></a></div>
			<?php } ?>
			<div class="header-right">
				<div class="header-phone">
                	<?php if(!empty($contact_number1_lable) || !empty($contact_number2_lable)) { ?>
                	<div class="phone-box">
                    	<?php if(isset($contact_number1_lable) && !empty($contact_number1_lable)) { ?>
                    	<span><?php echo $contact_number1_lable; ?></span>
                    	<?php } ?>
                    	<?php if(isset($contact_number1) && !empty($contact_number1)) { ?>
	                    <a class="icon-call" href="tel:<?php echo $contact_number1; ?>"><em class="hide-mobi"><?php echo $contact_number1; ?></em></a>
	                    <?php } ?>
                    </div>
                    <div class="phone-box">
                    	<?php if(isset($contact_number2_lable) && !empty($contact_number2_lable)) { ?>
                    	<span><?php echo $contact_number2_lable; ?></span>
                    	<?php } ?>
                    	<?php if(isset($contact_number2) && !empty($contact_number2)) { ?>
	                    <a class="icon-call2" href="tel:<?php echo $contact_number2; ?>"><i class="fa fa-phone" aria-hidden="true"></i><em class="hide-mobi"><?php echo $contact_number2; ?></em></a>
	                    <?php } ?>
                    </div>
                    <?php } ?>
                </div>
                <div class="header-buttons"> 
                    <?php if(isset($header_button_label) && !empty($header_button_label)) { ?>
                    	<a class="btn" href="<?php echo $header_button_link; ?>"><?php echo $header_button_label; ?></a>
                    	<a class="mobile-quote" href="<?php echo $header_button_link; ?>"><i class="fa fa-comments" aria-hidden="true"></i></a>
                    <?php } ?>
                    <?php if(isset($checkout_button) && !empty($checkout_button)) { ?>
                    <div class="cart-checkout-btn">
                        <a href="<?php echo $checkout_button_link; ?>" class="btn checkout-btn"><?php echo $checkout_button; ?></a>
                        <a href="<?php echo $cart_link; ?>" class="btn cart-btn"><i class="fa fa-shopping-cart" aria-hidden="true"></i>
</a>
                    </div>
                    <?php } ?>
                </div>
                

                <!--Mobile Menu Start-->    
                <div class="menuicon mobilemenuicon">
                    <span class="icon-bar top-icon-bar"></span>
                    <span class="icon-bar middle-icon-bar"></span>
                    <span class="icon-bar bottom-icon-bar"></span>
                </div>
			</div>			
		</div>
        
        <div class="nav-main">
            <nav>
            	<?php
                    $defaults = array( 
                        'menu' 			=>'Main Menu',
                        'menu_class' 	=>'clearfix',
                        'theme_location'=>'top'
            		);
                    wp_nav_menu( $defaults );
    			?>
            </nav>
        </div>
        
	</div>
</header>
<!--Header End-->
<div class="clearfix"></div>