<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */
$bs_background_image = get_field('bs_background_image');
$bgimg_style = ($bs_background_image != '') ? ' style="background-image: url('.$bs_background_image.');"' : '';
$bs_image = get_field('bs_image');
$bs_content = get_field('bs_content');
$as_type = get_field('as_type');
$as_video = get_field('as_video');
$as_video_image = get_field('as_video_image');
$poster = ($as_video_image != '') ? ' poster="'.$as_video_image.'"' : '';
$as_iframe = get_field('as_iframe');
$as_title = get_field('as_title');
$as_content = get_field('as_content');
$ss_title = get_field('ss_title');
$ss_button_label = get_field('ss_button_label');
$cs_title = get_field('cs_title');
$cs_subtitle = get_field('cs_subtitle');
$cs_form = get_field('cs_form');
$the_service = new WP_Query(array('post_type' => 'tc_service', 'posts_per_page' => -1, 'post_status' => 'publish', 'orderby' => 'post_date', 'order' => 'DESC'));
get_header(); ?>

<!-- Page Content -->
<div class="middle-section">
	<!-- Banner Section Start -->
	<div class="banner-section"<?php echo $bgimg_style; ?>>
		<?php if($bs_content != '') : ?>
			<div class="caption">
				<div class="container">
					<div class="caption-inner wow fadeInLeft" data-wow-delay="0.3s">
						<?php echo $bs_content; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<?php if($bs_image != '') : ?>
			<div class="banner-right-img wow fadeInRight" data-wow-delay="0.3s">
				<img src="<?php echo $bs_image; ?>" alt="Doctor" />
			</div>
		<?php endif; ?>
	</div>
	<!-- Banner Section End -->
	<!-- Section 1 Start -->
	<div class="section1">
		<div class="max-container">
	    	<div class="about-inner-section">
	    		<?php /*?><div class="col-2">
	    			<?php if($as_video != '' || $as_iframe != '') : ?>
		    			<div class="video-left wow fadeInRight" data-wow-delay="0.5s">
		    				<?php if($as_type == 'Upload Video') : ?>
			    				<video<?php echo $poster; ?> controls>
									<source src="<?php echo $as_video; ?>" type="video/mp4">
			    				</video>
			    			<?php endif; ?>
			    			<?php echo ($as_type == 'Video Iframe') ? $as_iframe : ''; ?>
		    			</div>
		    		<?php endif; ?>
	    		</div><?php */?>
	    		<div class="center clearfix">
	    			<?php if($as_title != '' || $as_content != '') : ?>
		    			<div class="about-right-part wow fadeInLeft" data-wow-delay="0.5s">
		    				<?php echo ($as_title != '') ? '<h2>'.$as_title.'</h2>' : ''; ?>
		    				<?php echo ($as_content != '') ? $as_content : ''; ?>
		    			</div>
	    			<?php endif; ?>
	    		</div>
	    	</div>
    	</div>
	</div>
	<!-- Section 1 End -->
	<!-- Section 2 Start -->
	<?php if($the_service->have_posts()) : ?>
	<div class="section2">
    	<div class="max-container">
        
		<?php if($ss_title != '') : ?>
			<div class="lets-us center wow fadeInUp" data-wow-delay="0.4s">
				<span>
					<?php echo $ss_title; ?>
					<a href="#Let-Us-Serve" class="btn btn-bounce"><i class="ei ei-arrow_carrot-down"></i></a>
				</span>
			</div>
		<?php endif; ?>
		
			<div class="services-section-inner wow fadeInUp" data-wow-delay="0.5s" id="Let-Us-Serve">
				<div class="services-slider clearfix">
					<?php while($the_service->have_posts()) : $the_service->the_post(); ?>
						<?php if(has_post_thumbnail()) : ?>
						<div class="col-4">
							<div class="services-box">
								<!-- <a href="<?php // echo get_permalink(); ?>"> -->
									<div class="figure effect-sadie">
										
		    								<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt="">
		    							
										<div class="figcaption center">
											<h4><?php echo get_the_title(); ?></h4>
											<?php if(has_excerpt()) : ?>
					    						<p><?php echo get_the_excerpt(); ?></p>
					    					<?php endif; ?>
										</div>
										<div class="plus-icon">
											<span class="btn plus-btn"><i class="ei ei-plus"></i></span>
										</div>
									</div>
								<!-- </a> -->
							</div>
						</div>
						<?php endif; ?>
					<?php endwhile; wp_reset_query(); ?>
				</div>
				<?php if($ss_button_label != '') : ?>
					<div class="center">
						<a href="<?php the_field('ss_button_link'); ?>" class="btn"><span><?php echo $ss_button_label; ?></span></a>
					</div>
				<?php endif; ?>
			</div>
            
		</div>
	</div>
	<?php endif; ?>
	<!-- Section 2 End -->

<?php get_footer();