<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="">
<meta name="author" content="">
<meta property="og:image" content="<?php the_field('site_favicon_bookmark', 'option'); ?>" />
<link rel="apple-touch-icon" href="<?php the_field('site_favicon_bookmark', 'option'); ?>">
<link rel="apple-touch-icon-precomposed" href="<?php the_field('site_favicon_bookmark', 'option'); ?>" />
<link rel="shortcut icon" type="image/x-icon" href="<?php the_field('site_favicon', 'option'); ?>" />
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,300i,400,400i,600,600i,700,700i" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/elegant-icons.min.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css" rel="stylesheet">
<!-- WP Head Start -->
<?php wp_head(); ?>
<!-- WP Head End -->

<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-133758008-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-133758008-1');
</script>

</head>
<body <?php body_class(); ?>>
<?php 
	$button_1_label = get_field('button_1_label', 'option');
	$phone = get_field('phone', 'option');
	$button_2_label = get_field('button_2_label', 'option');
	$button_2_link = get_field('button_2_link', 'option');
	$board_certified_text = get_field('board_certified_text', 'option');
?>
<!--MMenu-->
<div class="mobile-menu-block clearfix">    
    <div class="mobile-menu-inner clearfix">
    	<h4><img src="<?php the_field('site_logo', 'option'); ?>" alt="<?php bloginfo('title', 'display'); ?>"></h4>
    	<?php wp_nav_menu(array('menu' => 'nav_menu', 'container' => 'nav', 'container_class' => 'mobile-nav', 'menu_class' => 'clearfix')); ?>
    </div>
</div>
<div class="menu-open-overlay"></div>

<!--Header Start-->
<header class="header">
	<div class="header-main clearfix">        	
        <div class="max-container">
            <div class="header-middle clearfix">
                <div class="logo">
                    <a href="<?php echo home_url(); ?>" title="<?php bloginfo('title', 'display'); ?>"><img src="<?php the_field('site_logo', 'option'); ?>" alt=""></a>
                </div>
                <div class="header-right">
                	<div class="head-top-right clearfix">
                    	<!--Mobile Menu Start-->    
                        <div class="menuicon mobilemenuicon">
                            <span class="icon-bar top-icon-bar"></span>
                            <span class="icon-bar middle-icon-bar"></span>
                            <span class="icon-bar bottom-icon-bar"></span>
                        </div>
                    </div>
                	<div class="nav-main clearfix">
                        <?php wp_nav_menu(array('menu' => 'nav_menu', 'container' => 'nav', 'menu_class' => 'clearfix')); ?>
                    </div>
                    <div class="two-buttons">
                    	<ul>
                    		<?php if($phone != '' && $button_1_label != '') : ?>
                    			<li><a href="tel:<?php echo $phone; ?>" class="btn"><i class="ei ei-phone"></i><span><?php echo $button_1_label; ?></span></a></li>
                    		<?php endif; ?>	
                    		<?php if($button_2_label != '') : ?>
                    			<li><a href="<?php echo $button_2_link; ?>" class="btn appointment-btn"><i class="ei ei-clipboard"></i><span><?php echo $button_2_label; ?></span></a></li>
                    		<?php endif; ?>	
                    	</ul>
                    </div>
                </div>
            </div>
        </div>
	</div>
    
    <?php if($board_certified_text != '') : ?>
        <div class="banner-message clearfix">
        	<h2><?php echo $board_certified_text; ?></h2>
        </div>
    <?php endif; ?>	
    
</header>
<?php 
    $the_service = new WP_Query(array('post_type' => 'tc_service', 'posts_per_page' => -1, 'post_status' => 'publish', 'orderby' => 'post_date', 'order' => 'DESC'));
    if($the_service->have_posts()) :
?>
<div class="top-services-section">
    <div class="max-container">
        <div class="top-services-inner">
            <ul>
                <?php while($the_service->have_posts()) : $the_service->the_post(); ?>
                <li><a href="<?php echo get_permalink(); ?>"><i class="ei ei-arrow_carrot-2right"></i> <?php echo get_the_title(); ?></a></li>
                <?php endwhile; wp_reset_query(); ?>
            </ul>
        </div>
    </div>
</div>
<?php endif; ?>
<!--Header End-->