<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

get_header(); 

$banner_image = get_field('banner_image');
$bimg_style = ($banner_image != '') ? ' style="background-image:url('.$banner_image.');"' : '';
$custom_title = get_field('custom_title');

?>
<div class="middle-section">
	<!-- Banner Section Start -->
    <div class="inner-banner-section clearfix"<?php echo $bimg_style; ?>>
    	<div class="container">
            <div class="caption">
            	<div class="caption-inner">
                	<h1><?php echo ($custom_title != '') ? $custom_title : get_the_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>
<!-- Banner Section End -->
<div class="section1-internal entry-content">
    	<div class="container">

			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

				get_template_part( 'template-parts/post/content', get_post_format() );

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

				echo ("<div class='pagination blog-pagination'>");
				the_post_navigation( array(
					'prev_text' => '<span class="screen-reader-text">' . '</span><span aria-hidden="true" class="nav-subtitle btn">' . __( 'Previous', 'twentyseventeen' ) . '</span>',
					'next_text' => '<span class="screen-reader-text">' . '</span><span aria-hidden="true" class="nav-subtitle btn">' . __( 'Next', 'twentyseventeen' ) . '</span>',
				) );
				echo ("</div>");

			endwhile; // End of the loop.
			?>

	</div>
</div>

<?php get_footer();
