<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="pst-wrppr-child">
		<?php
		if ( is_sticky() && is_home() ) :
			echo twentyseventeen_get_svg( array( 'icon' => 'thumb-tack' ) );
		endif;
		?>
		<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>
			<div class="post-thumbnail">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( 'twentyseventeen-featured-image' ); ?>
				</a>
			</div><!-- .post-thumbnail -->
		<?php endif; ?>

		<div class="entry-content">
			<a href="<?php the_permalink(); ?>">
				<?php the_title( '<h2 class="entry-title">', '</h2>' ); ?>				
			</a>
			
			<?php echo get_the_excerpt() ?>
			
		</div><!-- .entry-content -->
		
		<div class="clear"></div>		

		<?php
		if ( is_single() ) {
			twentyseventeen_entry_footer();
		}
		?>
	</div>
</article><!-- #post-## -->
