<?php

/**
 * Template Name: Services
 *
 */
$banner_image = get_field('banner_image');
$bimg_style = ($banner_image != '') ? ' style="background-image:url('.$banner_image.');"' : '';
$custom_title = get_field('custom_title');

$the_service = new WP_Query(array('post_type' => 'tc_service', 'posts_per_page' => -1, 'post_status' => 'publish', 'orderby' => 'post_date', 'order' => 'DESC'));

get_header(); ?>
<div class="middle-section services-page">
	<!-- Banner Section Start -->
    <div class="inner-banner-section clearfix"<?php echo $bimg_style; ?>>
    	<div class="container">
            <div class="caption">
            	<div class="caption-inner">
                	<h1><?php echo ($custom_title != '') ? $custom_title : get_the_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>
	<!-- Banner Section End -->
    <div class="section1-internal entry-content padding-b-0">
    	<div class="container">
	        <?php if($the_service->have_posts()) : ?>
                <div class="services-section-inner" id="Let-Us-Serve">
                    <ul class="clearfix services-listing">
                        <?php while($the_service->have_posts()) : $the_service->the_post(); ?>
                            <li><?php echo get_the_title(); ?></li>
                        <?php endwhile; wp_reset_query(); ?>
                    </ul>
                    <?php if($ss_button_label != '') : ?>
                        <div class="center">
                            <a href="<?php the_field('ss_button_link'); ?>" class="btn"><span><?php echo $ss_button_label; ?></span></a>
                        </div>
                    <?php endif; ?>
                    <div class="service-page-content">
                        <?php echo the_content(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php get_footer();